<?php

// Add the administrator field
if (self::$db_alter->fetch_table_info('administrator'))
{
	self::$db_alter->add_field(array(
		'name'       => 'dbtech_vbsecurityadminperms',
		'type'       => 'int',
		'length'     => '10',
		'attributes' => 'unsigned',
		'null'       => false,	// True = NULL, false = NOT NULL
		'default'    => '0'
	));
	self::$db_alter->add_field(array(
		'name'       => 'adminpassword',
		'type'       => 'char',
		'length'     => '32',
		'null'       => false,	// True = NULL, false = NOT NULL
		'default'    => ''
	));
	self::report('Altered Table', 'administrator');
}

if (self::$db_alter->fetch_table_info('usergroup'))
{
	self::$db_alter->add_field(array(
		'name'       => 'dbtech_vbsecuritypermissions',
		'type'       => 'int',
		'length'     => '10',
		'attributes' => 'unsigned',
		'null'       => false,	// True = NULL, false = NOT NULL
		'default'    => '0'
	));
	self::report('Altered Table', 'usergroup');
}


self::$db->query_write("
	CREATE TABLE IF NOT EXISTS `" . TABLE_PREFIX  . "dbtech_vbsecurity_adminstrikes` (
		`adminstrikesid` int(10) NOT NULL AUTO_INCREMENT,
		`userid` int(10) unsigned NOT NULL DEFAULT '0',
		`ipaddress` char(15) NOT NULL DEFAULT '',
		`dateline` int(10) unsigned NOT NULL DEFAULT '0',
		PRIMARY KEY (`adminstrikesid`),
		KEY `userid` (`userid`)
	) ENGINE=MyISAM
");
self::report('Created Table', 'dbtech_vbsecurity_adminstrikes');

self::$db->query_write("
	CREATE TABLE IF NOT EXISTS `" . TABLE_PREFIX  . "dbtech_vbsecurity_changelog` (
		`changelogid` int(10) unsigned NOT NULL AUTO_INCREMENT,
		`userid` int(10) unsigned NOT NULL DEFAULT '0',
		`ipaddress` char(15) NOT NULL DEFAULT '',
		`dateline` int(10) unsigned NOT NULL DEFAULT '0',
		`script` varchar(50) NOT NULL DEFAULT '',
		`action` varchar(20) NOT NULL DEFAULT '',
		`id` int(10) NOT NULL DEFAULT '0',
		`title` varchar(200) NOT NULL DEFAULT '',
		`field` varchar(50) NOT NULL DEFAULT '',
		`change` varchar(200) NOT NULL DEFAULT '',
		PRIMARY KEY (`changelogid`),
		KEY `userid` (`userid`)
	) ENGINE=MyISAM
");
self::report('Created Table', 'dbtech_vbsecurity_changelog');

self::$db->query_write("
	CREATE TABLE IF NOT EXISTS `" . TABLE_PREFIX  . "dbtech_vbsecurity_loginstrikes` (
		`loginstrikesid` int(10) unsigned NOT NULL AUTO_INCREMENT,
		`dateline` int(10) unsigned NOT NULL DEFAULT '0',
		`ipaddress` char(15) NOT NULL DEFAULT '',
		`username` varchar(100) NOT NULL DEFAULT '',
		PRIMARY KEY (`loginstrikesid`),
		KEY `dateline` (`dateline`),
		KEY `ipaddress` (`ipaddress`)
	) ENGINE=MyISAM
");
self::report('Created Table', 'dbtech_vbsecurity_loginstrikes');

self::$db->query_write("
	CREATE TABLE IF NOT EXISTS `" . TABLE_PREFIX  . "dbtech_vbsecurity_snapshot` (
		`snapshotid` int(10) unsigned NOT NULL AUTO_INCREMENT,
		`dateline` int(10) unsigned NOT NULL DEFAULT '0',
		`data` mediumtext NOT NULL,
		PRIMARY KEY (`snapshotid`)
	) ENGINE=MyISAM
");
self::report('Created Table', 'dbtech_vbsecurity_snapshot');

self::$db->query_write("
	REPLACE INTO `" . TABLE_PREFIX  . "datastore` 
		(title, data, unserialize)
	VALUES (
		'dbtech_vbsecurity_actions',
		" . self::$db->sql_prepare(trim(serialize(array()))) . ",
		'1'
	)
");
self::report('Populated Table', 'datastore');